/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal.buffer;

import com.mulesoft.agent.buffer.Buffer;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferFactory;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.exception.BufferException;
import com.mulesoft.agent.handlers.internal.buffer.impl.DiskBuffer;
import com.mulesoft.agent.handlers.internal.buffer.impl.MemoryBuffer;
import java.io.Serializable;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="mule.agent.buffer.factory.default")
@Singleton
public class DefaultBufferFactory<T extends Serializable>
implements BufferFactory<T> {
    public Buffer<T> buildBuffer(BufferType bufferType, BufferConfiguration bufferConfiguration) throws BufferException {
        Object buffer;
        switch (bufferType) {
            case MEMORY: {
                buffer = new MemoryBuffer();
                break;
            }
            case DISK: {
                buffer = new DiskBuffer(bufferConfiguration);
                break;
            }
            default: {
                throw new BufferException(String.format("Invalid BufferType [%s]", bufferType.toString()));
            }
        }
        return buffer;
    }
}

