/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal.buffer;

import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferConfigurationFactory;
import com.mulesoft.agent.buffer.BufferType;

public abstract class BaseBufferConfigurationFactory
implements BufferConfigurationFactory {
    private static final int DEFAULT_FLUSH_THREADS_NUMBER = 2;
    private static final int DEFAULT_RETRY_COUNT = 1;

    public BufferConfiguration create(long flushFrequency, int maximumCapacity, BufferType bufferType, String filePath) {
        BufferConfiguration bufferConfiguration = new BufferConfiguration();
        bufferConfiguration.setFlushFrequency(Long.valueOf(flushFrequency));
        bufferConfiguration.setType(bufferType);
        bufferConfiguration.setMaximumCapacity(Integer.valueOf(maximumCapacity));
        if (bufferType != BufferType.MEMORY) {
            bufferConfiguration.setFilePath(filePath);
        }
        bufferConfiguration.setRetryCount(Integer.valueOf(1));
        bufferConfiguration.setFlushThreadsNumber(Integer.valueOf(2));
        this.doConfigure(bufferConfiguration);
        return bufferConfiguration;
    }

    protected abstract void doConfigure(BufferConfiguration var1);
}

