/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="tracking.notification.internal.message.handler")
@Singleton
public class InternalTrackingNotificationHandler
extends BufferedHandler<AgentTrackingNotification> {
    private static final String TRACKING_NOTIFICATIONS = "tracking";
    private static final Logger LOGGER = LogManager.getLogger(InternalTrackingNotificationHandler.class);
    @Inject
    private List<AgentTransport<Request, Response>> transports;

    public boolean flush(Collection<AgentTrackingNotification> trackingNotifications) {
        for (AgentTrackingNotification trackingNotification : trackingNotifications) {
            Request request = new Request();
            request.setMethod("PUT");
            request.setResource(TRACKING_NOTIFICATIONS);
            request.setBody((Object)trackingNotification);
            for (AgentTransport<Request, Response> transport : this.transports) {
                try {
                    transport.send((Object)request);
                }
                catch (InsecureTransportException e) {
                    LOGGER.warn("Could not send tracking notification to external system via" + transport.getClass().getSimpleName() + ": the channel is insecure " + e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.warn("Could not send tracking notification to external system via " + transport.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        return true;
    }

    protected boolean canHandle(AgentTrackingNotification trackingNotification) {
        return this.isEnabled();
    }
}

