/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.scheduler.SchedulerNotification;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="scheduling.notification.internal.message.handler")
@Singleton
public class InternalSchedulingNotificationHandler
extends BufferedHandler<SchedulerNotification> {
    private static final Logger LOGGER = LogManager.getLogger(InternalSchedulingNotificationHandler.class);
    private static final String SCHEDULING_NOTIFICATIONS = "applications/{appName}/schedulers";
    @Inject
    private List<AgentTransport<Request, Response>> transports;
    @Configurable(value="true")
    protected boolean enabled;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean flush(Collection<SchedulerNotification> schedulerNotifications) {
        for (SchedulerNotification schedulerNotification : schedulerNotifications) {
            try {
                this.sendNotification(schedulerNotification);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Could not send message to \"{}\" for application {} due an issue when encoding the path params : {}", (Object)SCHEDULING_NOTIFICATIONS, (Object)schedulerNotification.getApplicationName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
        return true;
    }

    private void sendNotification(SchedulerNotification notification) throws UnsupportedEncodingException {
        Request request = this.buildRequest(notification);
        for (AgentTransport<Request, Response> transport : this.transports) {
            try {
                transport.send((Object)request);
            }
            catch (InsecureTransportException e) {
                LOGGER.warn("Could not send message to external system via {} : the channel is insecure {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
            catch (Exception e) {
                LOGGER.warn("Could not send message to external system via {} : {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }

    protected boolean canHandle(SchedulerNotification schedulerNotification) {
        return this.isEnabled();
    }

    private Request buildRequest(SchedulerNotification notification) throws UnsupportedEncodingException {
        Request request = new Request();
        request.setMethod("PUT");
        request.setResource(SCHEDULING_NOTIFICATIONS);
        request.setBody((Object)notification);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appName", notification.getApplicationName());
        request.resolveResourceTemplate(params);
        return request;
    }
}

