/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.domain.cluster.PrimaryNodeNotification;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.services.OnOffSwitch;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="primary.node.notification.internal.message.handler")
@Singleton
public class InternalPrimaryNodeNotificationHandler
extends BufferedHandler<PrimaryNodeNotification> {
    private static final Logger LOGGER = LogManager.getLogger(InternalPrimaryNodeNotificationHandler.class);
    private static final String PRIMARY_NODE_NOTIFICATIONS = "clusters/primary";
    @Configurable(value="true")
    protected boolean enabled;
    @Inject
    private List<AgentTransport<Request, Response>> clients;

    @PostConfigure
    public void postConfigurable() throws AgentEnableOperationException {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
        }
    }

    protected boolean canHandle(PrimaryNodeNotification primaryNodeNotification) {
        return this.enabled;
    }

    protected boolean flush(Collection<PrimaryNodeNotification> primaryNodeNotifications) {
        for (PrimaryNodeNotification notification : primaryNodeNotifications) {
            Request request = new Request();
            request.setMethod("POST");
            request.setResource(PRIMARY_NODE_NOTIFICATIONS);
            for (AgentTransport<Request, Response> client : this.clients) {
                try {
                    client.send((Object)request);
                }
                catch (InsecureTransportException e) {
                    LOGGER.warn("Could not send message to external system via" + client.getClass().getSimpleName() + ": the channel is insecure " + e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.warn("Could not send message to external system via " + client.getClass().getSimpleName() + ": " + e.getMessage());
                }
            }
        }
        return true;
    }
}

