/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.flows.FlowStatusNotification;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="flow.status.notification.internal.message.handler")
@Singleton
public class InternalFlowStatusNotificationHandler
extends BufferedHandler<FlowStatusNotification> {
    private static final String FLOW_NOTIFICATIONS = "applications/{appName}/flows/{flowName}";
    @Configurable(value="true")
    protected boolean enabled;
    private static final Logger LOGGER = LogManager.getLogger(InternalFlowStatusNotificationHandler.class);
    @Inject
    private List<AgentTransport<Request, Response>> clients;

    protected boolean canHandle(FlowStatusNotification applicationMuleDeploymentNotification) {
        return this.enabled;
    }

    protected boolean flush(Collection<FlowStatusNotification> notifications) {
        for (FlowStatusNotification notification : notifications) {
            try {
                this.sendMuleNotification(notification);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Could not send message to \"{}\" for application {} and flow {} due an issue when encoding the path params : {}", (Object)FLOW_NOTIFICATIONS, (Object)notification.getApplicationName(), (Object)notification.getFlow().getName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
        return true;
    }

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void sendMuleNotification(FlowStatusNotification notification) throws UnsupportedEncodingException {
        Request request = this.buildRequest(notification);
        for (AgentTransport<Request, Response> client : this.clients) {
            try {
                client.send((Object)request);
            }
            catch (InsecureTransportException e) {
                LOGGER.warn("Could not send message to external system via {} : the channel is insecure {}", (Object)client.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
            catch (Exception e) {
                LOGGER.warn("Could not send message to external system via {} : {}", (Object)client.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }

    private Request buildRequest(FlowStatusNotification notification) throws UnsupportedEncodingException {
        Request request = new Request();
        request.setMethod("PUT");
        request.setResource(FLOW_NOTIFICATIONS);
        request.setBody((Object)notification);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("appName", notification.getApplicationName());
        params.put("flowName", notification.getFlow().getName());
        request.resolveResourceTemplate(params);
        return request;
    }
}

