/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.switcher.ConfigurationNotification;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="configuration.notification.internal.message.handler")
@Singleton
public class InternalConfigurationNotificationHandler
extends BufferedHandler<ConfigurationNotification> {
    private static final Logger LOGGER = LogManager.getLogger(InternalConfigurationNotificationHandler.class);
    private static final String CONFIGURATION_NOTIFICATION = "components/{componentId}";
    @Inject
    private List<AgentTransport<Request, Response>> transports;
    @Configurable(value="true")
    protected boolean enabled;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabled = state;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean flush(Collection<ConfigurationNotification> configurationNotifications) {
        for (ConfigurationNotification configurationNotification : configurationNotifications) {
            try {
                this.sendNotification(configurationNotification);
            }
            catch (UnsupportedEncodingException e) {
                LOGGER.warn("Could not send message to \"{}\" for component configuration {} due an issue when encoding the path params : {}", (Object)CONFIGURATION_NOTIFICATION, (Object)configurationNotification.getComponentId(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
        return true;
    }

    private void sendNotification(ConfigurationNotification configurationNotification) throws UnsupportedEncodingException {
        Request request = this.buildRequest(configurationNotification);
        for (AgentTransport<Request, Response> transport : this.transports) {
            try {
                transport.send((Object)request);
            }
            catch (InsecureTransportException e) {
                LOGGER.warn("Could not send message to external system via {} : the channel is insecure {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
            catch (Exception e) {
                LOGGER.warn("Could not send message to external system via {} : {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }

    protected boolean canHandle(ConfigurationNotification configurationNotification) {
        return this.isEnabled();
    }

    private Request buildRequest(ConfigurationNotification configurationNotification) throws UnsupportedEncodingException {
        Request request = new Request();
        request.setMethod("PUT");
        request.setResource(CONFIGURATION_NOTIFICATION);
        request.setBody((Object)configurationNotification);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("componentId", configurationNotification.getComponentId());
        request.resolveResourceTemplate(params);
        return request;
    }
}

