/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.handlers.internal;

import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.domain.action.ServerAction;
import com.mulesoft.agent.transport.AgentTransport;
import com.mulesoft.agent.transport.InsecureTransportException;
import com.mulesoft.agent.transport.Request;
import com.mulesoft.agent.transport.Response;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="action.status.internal.message.handler")
@Singleton
public class InternalActionStatusHandler
extends BufferedHandler<ServerAction> {
    private static final Logger LOGGER = LogManager.getLogger(InternalActionStatusHandler.class);
    private static final String ACTION_STATUS_NOTIFICATIONS_PATH = "actions";
    private boolean enabled = true;
    @Inject
    private List<AgentTransport<Request, Response>> transports;

    public boolean isEnabled() {
        return this.enabled;
    }

    protected boolean canHandle(ServerAction serverAction) {
        return this.enabled;
    }

    protected boolean flush(Collection<ServerAction> serverActions) {
        for (ServerAction serverAction : serverActions) {
            Request request = new Request();
            request.setMethod("PUT");
            request.setResource(ACTION_STATUS_NOTIFICATIONS_PATH);
            request.setBody((Object)serverAction);
            this.send(request);
        }
        return true;
    }

    private void send(Request request) {
        for (AgentTransport<Request, Response> transport : this.transports) {
            try {
                transport.send((Object)request);
            }
            catch (InsecureTransportException e) {
                LOGGER.warn("Could not send message to external system via {} : the channel is insecure {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
            catch (Exception e) {
                LOGGER.warn("Could not send message to external system via {} : {}", (Object)transport.getClass().getSimpleName(), (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                LOGGER.debug((Object)e);
            }
        }
    }
}

