/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.internal;

import java.io.InputStream;
import java.lang.module.ModuleDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.api.annotation.jpms.PrivilegedApi;
import org.mule.runtime.api.util.MuleSystemProperties;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.api.discoverer.ModuleDiscoverer;
import org.mule.runtime.container.internal.ClasspathModuleDiscoverer;
import org.mule.runtime.jpms.api.MuleContainerModule;

public class JpmsModuleLayerModuleDiscoverer
implements ModuleDiscoverer {
    private final ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer;

    public JpmsModuleLayerModuleDiscoverer(ClasspathModuleDiscoverer fallbackClasspathModuleDiscoverer) {
        this.fallbackClasspathModuleDiscoverer = fallbackClasspathModuleDiscoverer;
    }

    @Override
    public List<MuleContainerModule> discover() {
        if (!MuleSystemProperties.classloaderContainerJpmsModuleLayer()) {
            return this.fallbackClasspathModuleDiscoverer.discover();
        }
        List<MuleContainerModule> discoveredModules = this.getModules(JpmsModuleLayerModuleDiscoverer.resolveLayer(this.getClass().getModule())).stream().map(jpmsModule -> {
            if (jpmsModule.getDescriptor().isAutomatic()) {
                MuleModule muleModule;
                block11: {
                    InputStream stream = jpmsModule.getResourceAsStream("/" + this.fallbackClasspathModuleDiscoverer.getModulePropertiesFileName());
                    try {
                        Properties moduleProperties = new Properties();
                        if (stream != null) {
                            moduleProperties.load(stream);
                        } else {
                            moduleProperties.put("module.name", jpmsModule.getName());
                        }
                        muleModule = this.fallbackClasspathModuleDiscoverer.createModule(moduleProperties);
                        if (stream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot create fallback muleContainer module for '" + jpmsModule.getName() + "'", e);
                        }
                    }
                    stream.close();
                }
                return muleModule;
            }
            return new JpmsMuleContainerModule((Module)jpmsModule);
        }).collect(Collectors.toList());
        ModuleLayer.boot().modules().stream().filter(jpmsModule -> jpmsModule.getName().startsWith("org.mule.runtime.") || jpmsModule.getName().startsWith("com.mulesoft.mule.")).map(JpmsMuleContainerModule::new).forEach(discoveredModules::add);
        return discoveredModules;
    }

    private static ModuleLayer resolveLayer(Module module) {
        return Objects.requireNonNull(module.getLayer(), "Module '" + module.getName() + "' (classloader: " + String.valueOf(module.getClassLoader()) + ") does not belong to a layer");
    }

    private Set<Module> getModules(ModuleLayer layer) {
        HashSet<Module> modules = new HashSet<Module>(layer.modules());
        for (ModuleLayer parent : layer.parents()) {
            modules.addAll(this.getModules(parent));
        }
        return modules.stream().filter(module -> module.getName().startsWith("org.mule") || module.getName().startsWith("com.mulesoft")).collect(Collectors.toSet());
    }

    public static class JpmsMuleContainerModule
    implements MuleContainerModule {
        private final Module jpmsModule;
        private final Set<String> exportedPackages;
        private final Set<String> privilegedExportedPackages;
        private final Set<String> privilegedArtifacts;

        public JpmsMuleContainerModule(Module jpmsModule) {
            this.jpmsModule = jpmsModule;
            if (jpmsModule.isAnnotationPresent(PrivilegedApi.class)) {
                PrivilegedApi privilegedApiAnnotation = jpmsModule.getAnnotation(PrivilegedApi.class);
                this.privilegedExportedPackages = Arrays.stream(privilegedApiAnnotation.privilegedPackages()).collect(Collectors.toSet());
                this.privilegedArtifacts = Arrays.stream(privilegedApiAnnotation.privilegedArtifactIds()).collect(Collectors.toSet());
            } else {
                this.privilegedExportedPackages = Collections.emptySet();
                this.privilegedArtifacts = Collections.emptySet();
            }
            this.exportedPackages = Stream.concat(Stream.concat(this.getUnqualifiedExports(jpmsModule), this.getOpensToJpmsUtils(jpmsModule)), this.resolveTransitiveExportedPackages(jpmsModule)).filter(Predicate.not(this.privilegedExportedPackages::contains)).collect(Collectors.toSet());
        }

        private Stream<String> getUnqualifiedExports(Module jpmsModule) {
            return jpmsModule.getDescriptor().exports().stream().filter(export -> export.targets().isEmpty()).map(ModuleDescriptor.Exports::source);
        }

        private Stream<String> getOpensToJpmsUtils(Module jpmsModule) {
            return jpmsModule.getDescriptor().opens().stream().filter(open -> open.targets().contains("org.mule.runtime.jpms.utils")).map(ModuleDescriptor.Opens::source);
        }

        private Stream<String> resolveTransitiveExportedPackages(Module jpmsModule) {
            return jpmsModule.getDescriptor().requires().stream().filter(required -> required.modifiers().contains((Object)ModuleDescriptor.Requires.Modifier.TRANSITIVE)).flatMap(required -> {
                Module requiredTransitiveModule = JpmsModuleLayerModuleDiscoverer.resolveLayer(this.getClass().getModule()).findModule(required.name()).get();
                if (requiredTransitiveModule.getDescriptor().isAutomatic()) {
                    return requiredTransitiveModule.getPackages().stream();
                }
                return JpmsModuleLayerModuleDiscoverer.resolveLayer(jpmsModule).findModule(required.name()).map(requiredModule -> Stream.concat(this.getUnqualifiedExports((Module)requiredModule), this.resolveTransitiveExportedPackages((Module)requiredModule))).orElse(Stream.empty());
            });
        }

        public String getName() {
            return this.jpmsModule.getName();
        }

        public Set<String> getExportedPackages() {
            return this.exportedPackages;
        }

        public Set<String> getExportedPaths() {
            return Collections.emptySet();
        }

        public Set<String> getPrivilegedExportedPackages() {
            return this.privilegedExportedPackages;
        }

        public Set<String> getPrivilegedArtifacts() {
            return this.privilegedArtifacts;
        }

        public String toString() {
            return "JpmsMuleContainerModule[" + this.getName() + "]";
        }
    }
}

