/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.container.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Preconditions;

public class MuleFoldersUtil {
    public static final String EXECUTION_FOLDER = ".mule";
    public static final String LIB_FOLDER = "lib";
    public static final String SHARED_FOLDER = "shared";
    public static final String APPS_FOLDER = "apps";
    public static final String PLUGINS_FOLDER = "plugins";
    public static final String DOMAINS_FOLDER = "domains";
    public static final String CONTAINER_APP_PLUGINS = "plugins";
    public static final String SERVER_PLUGINS = "server-plugins";
    public static final String CONF = "conf";
    public static final String USER_FOLDER = "user";
    public static final String PATCHES_FOLDER = "patches";
    public static final String ARTIFACT_PATCHES_FOLDER = "mule-artifact-patches";
    public static final String SERVICES_FOLDER = "services";
    private static final String MODULES_FOLDER = "modules";
    private static final String NATIVE_LIBRARIES_FOLDER = "native-libraries";

    private MuleFoldersUtil() {
    }

    @Deprecated(forRemoval=false, since="4.11")
    public static File getMuleHomeFolder() {
        return MuleFoldersUtil.getMuleHomeFolderPath().toFile();
    }

    public static Path getMuleHomeFolderPath() {
        Path muleHome = MuleFoldersUtil.getMuleHomePath().orElse(null);
        if (muleHome == null) {
            muleHome = Path.of(".", new String[0]);
        }
        return muleHome;
    }

    private static Optional<Path> getMuleHomePath() {
        String muleHome = System.getProperty("mule.home");
        return Optional.ofNullable(muleHome != null ? Path.of(muleHome, new String[0]) : null);
    }

    public static File getMuleBaseFolder() {
        return MuleFoldersUtil.getMuleBaseFolderPath().toFile();
    }

    public static Path getMuleBaseFolderPath() {
        Path muleBase = MuleFoldersUtil.getMuleBasePath().orElse(null);
        if (muleBase == null) {
            muleBase = MuleFoldersUtil.getMuleHomeFolderPath();
        }
        return muleBase;
    }

    private static Optional<Path> getMuleBasePath() {
        String muleBaseVar = System.getProperty("mule.base");
        if (muleBaseVar != null && !muleBaseVar.trim().equals("") && !muleBaseVar.equals("%MULE_BASE%")) {
            try {
                return Optional.of(Path.of(muleBaseVar, new String[0]).toRealPath(new LinkOption[0]));
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
        return MuleFoldersUtil.getMuleHomePath();
    }

    public static File getServicesFolder() {
        return MuleFoldersUtil.getServicesFolderPath().toFile();
    }

    public static Path getServicesFolderPath() {
        return MuleFoldersUtil.getMuleBaseFolderPath().resolve(SERVICES_FOLDER);
    }

    public static File getServiceFolder(String name) {
        Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)name) ? 1 : 0) != 0, (String)"name cannot be empty");
        return MuleFoldersUtil.getServicesFolderPath().resolve(name).toFile();
    }

    public static File getServerPluginsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), SERVER_PLUGINS);
    }

    public static Path getServerPluginsFolderPath() {
        return MuleFoldersUtil.getMuleBaseFolderPath().resolve(SERVER_PLUGINS);
    }

    public static File getConfFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), CONF);
    }

    public static File getDomainsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), DOMAINS_FOLDER);
    }

    public static Path getDomainsFolderPath() {
        return MuleFoldersUtil.getMuleBaseFolderPath().resolve(DOMAINS_FOLDER);
    }

    public static File getDomainFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainsFolder(), domainName);
    }

    public static File getDomainLibFolder(String domainName) {
        return new File(MuleFoldersUtil.getDomainFolder(domainName), LIB_FOLDER);
    }

    public static File getAppsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), APPS_FOLDER);
    }

    public static Path getAppsFolderPath() {
        return MuleFoldersUtil.getMuleBaseFolderPath().resolve(APPS_FOLDER);
    }

    public static File getAppFolder(String appName) {
        return new File(MuleFoldersUtil.getAppsFolder(), appName);
    }

    public static File getAppDataFolder(String appDataFolder) {
        return new File(MuleFoldersUtil.getExecutionFolder(), appDataFolder);
    }

    public static File getAppLibFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppLibsFolderPath());
    }

    public static File getAppPluginsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppPluginsFolderPath());
    }

    public static String getAppPluginsFolderPath() {
        return "plugins" + File.separator;
    }

    public static File getAppSharedLibsFolder(String appName) {
        return new File(MuleFoldersUtil.getAppFolder(appName), MuleFoldersUtil.getAppSharedLibsFolderPath());
    }

    public static String getAppSharedLibsFolderPath() {
        return MuleFoldersUtil.getAppLibsFolderPath() + SHARED_FOLDER + File.separator;
    }

    private static String getAppLibsFolderPath() {
        return LIB_FOLDER + File.separator;
    }

    public static File getExecutionFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), EXECUTION_FOLDER);
    }

    public static Path getExecutionFolderPath() {
        return MuleFoldersUtil.getMuleBaseFolderPath().resolve(EXECUTION_FOLDER);
    }

    public static File getMuleLibFolder() {
        return new File(MuleFoldersUtil.getMuleHomeFolder(), LIB_FOLDER);
    }

    public static Path getMuleLibFolderPath() {
        return MuleFoldersUtil.getMuleHomeFolderPath().resolve(LIB_FOLDER);
    }

    public static File getUserLibFolder() {
        return new File(MuleFoldersUtil.getMuleLibFolder(), USER_FOLDER);
    }

    public static File getPatchesLibFolder() {
        return new File(MuleFoldersUtil.getMuleLibFolder(), PATCHES_FOLDER);
    }

    public static File getArtifactPatchesLibFolder() {
        return new File(MuleFoldersUtil.getPatchesLibFolder(), ARTIFACT_PATCHES_FOLDER);
    }

    public static File getContainerAppPluginsFolder() {
        return new File(MuleFoldersUtil.getMuleBaseFolder(), "plugins");
    }

    public static File getServicesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), SERVICES_FOLDER);
    }

    public static File getModulesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), MODULES_FOLDER);
    }

    public static File getNativeLibrariesTempFolder() {
        return new File(MuleFoldersUtil.getExecutionFolder(), NATIVE_LIBRARIES_FOLDER);
    }

    public static File getAppNativeLibrariesTempFolder(String appName) {
        return new File(MuleFoldersUtil.getNativeLibrariesTempFolder(), appName);
    }

    public static File getAppNativeLibrariesTempFolder(String appName, String identifier) {
        return new File(new File(MuleFoldersUtil.getNativeLibrariesTempFolder(), appName), identifier);
    }
}

