/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Namespace;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.dom.IAttributeListWrapper;
import org.mule.tooling.core.dom.IAttributeWrapper;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.editor.xml.ConfigurableReconcilerStructuredTextViewer;
import org.mule.tooling.messageflow.editor.xml.DocIdReplacerUtils;
import org.mule.tooling.messageflow.editor.xml.MuleXMLStructuredRegionProcessor;
import org.mule.tooling.ui.MuleUIPlugin;
import org.mule.tooling.ui.preferences.MuleStudioPreferencePage;

class MuleXMLTextViewer
extends ConfigurableReconcilerStructuredTextViewer {
    private static final String SCHEMA_LOCATION_ATT_START = "xsi:schemaLocation=\"";
    private static final String SCHEMA_LOCATION_REGEX = "([^\"]*\"[^\"]*\")*[^\"]*xsi:schemaLocation=\"([^\"]*)\"([^\"]*\"[^\"]*\")*[^\"]*";
    private static final Pattern SCHEMA_LOCATION_PATTERN = Pattern.compile("([^\"]*\"[^\"]*\")*[^\"]*xsi:schemaLocation=\"([^\"]*)\"([^\"]*\"[^\"]*\")*[^\"]*");
    private static final List<String> DOCUMENT_ROOT_ELEMENTS = Arrays.asList(MuleProjectKind.APPLICATION.getXmlRootNodeName(), MuleProjectKind.DOMAIN.getXmlRootNodeName());
    private MultiPageMessageFlowEditor multiPageMessageFlowEditor;

    MuleXMLTextViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, MultiPageMessageFlowEditor multiPageMessageFlowEditor) {
        super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles);
        this.multiPageMessageFlowEditor = multiPageMessageFlowEditor;
    }

    @Override
    protected IReconciler getReconciler(SourceViewerConfiguration configuration) {
        MuleXMLStructuredRegionProcessor newReconciler = new MuleXMLStructuredRegionProcessor(this);
        newReconciler.setDocumentPartitioning("org.eclipse.wst.sse.core.default_structured_text_partitioning");
        return newReconciler;
    }

    private void addNamespaces(String clipboardContent) {
        boolean restorePosition;
        List<Namespace> newNamespaces = this.extractUnusedNamespaces(clipboardContent);
        ISelection selection = this.getSelection();
        int selectionOffset = 0;
        if (selection != null && selection instanceof TextSelection) {
            TextSelection ts = (TextSelection)selection;
            selectionOffset = ts.getOffset();
            restorePosition = true;
        } else {
            restorePosition = false;
        }
        IDocument doc = this.getDocument();
        String text = doc.get();
        boolean changed = false;
        IMuleProject muleProject = this.multiPageMessageFlowEditor.getFlowEditor().getMuleProject();
        ISchemaLocationLookup schemaLocationlookup = muleProject.getSchemaLocationLookup();
        for (Namespace newNamespace : newNamespaces) {
            String schemaLocations;
            String schemaLocation = schemaLocationlookup.getSchemaLocation(newNamespace);
            if (schemaLocation == null) continue;
            String prefix = newNamespace.getPrefix();
            String uri = newNamespace.getURI();
            for (String documentRootElement : DOCUMENT_ROOT_ELEMENTS) {
                String xmlns = "xmlns:" + prefix + "=\"" + uri + "\"";
                String muleTagStart = "<" + documentRootElement;
                int indexOfMuleTag = text.indexOf(muleTagStart);
                int endOfMule = indexOfMuleTag != -1 ? text.indexOf(62, indexOfMuleTag) : -1;
                String searchIn = indexOfMuleTag == -1 || endOfMule == -1 ? text : text.substring(indexOfMuleTag, endOfMule);
                if (indexOfMuleTag == -1 || searchIn.contains(xmlns)) continue;
                int insertInto = indexOfMuleTag + muleTagStart.length() + 1;
                String insertion = xmlns + "\n\t";
                changed = true;
                text = new StringBuilder(text).insert(insertInto, insertion).toString();
                if (!restorePosition || insertInto >= selectionOffset) continue;
                selectionOffset += insertion.length();
            }
            String schemaUriAndLocation = uri + " " + schemaLocation;
            Matcher schemaLocationMatcher = SCHEMA_LOCATION_PATTERN.matcher(text);
            if (!schemaLocationMatcher.matches() || (schemaLocations = schemaLocationMatcher.group(2)).contains(schemaUriAndLocation)) continue;
            int insertInto = schemaLocationMatcher.start(2);
            String insertion = "\n" + schemaUriAndLocation + " ";
            changed = true;
            text = new StringBuilder(text).insert(insertInto, insertion).toString();
            if (!restorePosition || insertInto >= selectionOffset) continue;
            selectionOffset += insertion.length();
        }
        if (changed) {
            doc.set(text);
            if (restorePosition) {
                this.setSelectedRange(selectionOffset, 0);
            }
        }
    }

    private List<Namespace> extractUnusedNamespaces(String clipboardContent) {
        Set<String> foundNamespaces = this.findNamespacesInText(clipboardContent);
        IAttributeListWrapper namespaceAttributes = this.multiPageMessageFlowEditor.getMuleConfiguration().getElement().getNamespaceAttributes();
        HashMap<String, Namespace> rootNamespacesMapping = new HashMap<String, Namespace>();
        for (IAttributeWrapper attribute : namespaceAttributes) {
            String prefix = attribute.getQName().getPrefix();
            rootNamespacesMapping.put(prefix, Namespace.get((String)prefix, (String)attribute.getText()));
        }
        ArrayList<Namespace> newNamespaces = new ArrayList<Namespace>();
        for (String foundNamespace : foundNamespaces) {
            boolean alreadyAdded = rootNamespacesMapping.containsKey(foundNamespace);
            boolean supportedByStudio = MultiPageMessageFlowEditor.getActive().getNamespaceByPrefix().containsKey(foundNamespace);
            if (alreadyAdded || !supportedByStudio) continue;
            newNamespaces.add((Namespace)MultiPageMessageFlowEditor.getActive().getNamespaceByPrefix().get(foundNamespace));
        }
        return newNamespaces;
    }

    private Set<String> findNamespacesInText(String clipboardContent) {
        HashSet<String> result = new HashSet<String>();
        Pattern p = Pattern.compile("<([a-z-]+):([a-z-]+)");
        Matcher m = p.matcher(clipboardContent);
        while (m.find()) {
            String foundNamespace = m.group(1);
            result.add(foundNamespace);
        }
        return result;
    }

    @Override
    public void doOperation(int operation) {
        if (operation == 5) {
            String originalClipboardContent = this.getClipboardContent();
            if (originalClipboardContent != null) {
                String replacedDocIds = DocIdReplacerUtils.replaceDocIds(originalClipboardContent);
                if (!replacedDocIds.equals(originalClipboardContent) && this.changeClipboardDialog()) {
                    Clipboard clipboard = new Clipboard(this.getDisplay());
                    TextTransfer textTransfer = TextTransfer.getInstance();
                    clipboard.setContents((Object[])new String[]{replacedDocIds}, new Transfer[]{textTransfer});
                    super.doOperation(operation);
                    clipboard.setContents((Object[])new String[]{originalClipboardContent}, new Transfer[]{textTransfer});
                    clipboard.dispose();
                } else {
                    super.doOperation(operation);
                }
                this.addNamespaces(originalClipboardContent);
            }
        } else {
            super.doOperation(operation);
        }
    }

    private boolean changeClipboardDialog() {
        boolean result;
        IPreferenceStore preferenceStore = MuleUIPlugin.getDefault().getPreferenceStore();
        String preference = preferenceStore.getString("replace_doc_id_when_paste");
        if (preference.equals(MuleStudioPreferencePage.ActionDialogState.PROMPT.name())) {
            MessageDialogWithToggle toggleDialog = MessageDialogWithToggle.openYesNoQuestion((Shell)this.getDisplay().getActiveShell(), (String)"Regenerate 'doc:id' Values", (String)"Occurrences of 'doc:id' have been detected in the clipboard contents. Keeping them might have side effects when editing custom metadata in the UI.\nDo you want them to be regenerated with unique values?", (String)"Remember my choice", (boolean)false, (IPreferenceStore)preferenceStore, (String)"replace_doc_id_when_paste");
            boolean bl = result = toggleDialog.getReturnCode() == 2;
            if (toggleDialog.getToggleState()) {
                String state = result ? MuleStudioPreferencePage.ActionDialogState.ALWAYS.name() : MuleStudioPreferencePage.ActionDialogState.NEVER.name();
                preferenceStore.setValue("replace_doc_id_when_paste", state);
            }
        } else {
            result = preference.equals(MuleStudioPreferencePage.ActionDialogState.ALWAYS.name());
        }
        return result;
    }

    private String getClipboardContent() {
        Clipboard clipboard = new Clipboard(this.getDisplay());
        TextTransfer plainTextTransfer = TextTransfer.getInstance();
        String contents = (String)clipboard.getContents((Transfer)plainTextTransfer, 1);
        clipboard.dispose();
        return contents;
    }

    private Display getDisplay() {
        StyledText textWidget = this.getTextWidget();
        if (textWidget == null || textWidget.isDisposed()) {
            return null;
        }
        Display display = textWidget.getDisplay();
        if (display != null && display.isDisposed()) {
            return null;
        }
        return display;
    }
}

