/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor.xml;

import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.mule.tooling.core.ModelUtils;
import org.mule.tooling.core.dom.w3c.impl.ElementWrapperW3C;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.model.messageflow.Compartment;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.model.messageflow.Route;
import org.mule.tooling.model.messageflow.SplitterNode;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitor;
import org.mule.tooling.model.messageflow.util.MessageFlowEntityVisitorAdapter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GoToNodeHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        GoToNodeHandler.showEntity();
        return null;
    }

    public static void showEntity() {
        MultiPageMessageFlowEditor muleEditor = MessageFlowUtils.getMultiPageMessageFlowEditor();
        ISelectionProvider selectionProvider = muleEditor.getSource().getSelectionProvider();
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        if (selection.getFirstElement() instanceof Element) {
            Element xmlElement = (Element)selection.getFirstElement();
            GoToNodeHandler.showElement(muleEditor, xmlElement);
        }
    }

    public static void showElement(MultiPageMessageFlowEditor muleEditor, Element xmlElement) {
        Display.getCurrent().asyncExec(() -> {
            boolean globalOrUnknown = GoToNodeHandler.isGlobalOrUnknown(xmlElement, muleEditor.getMuleConfiguration());
            if (globalOrUnknown) {
                muleEditor.openGlobalElementsPage();
            } else {
                muleEditor.openFlowEditorPage();
            }
            Optional<IMessageFlowEntity> result = new FindEntity(muleEditor.getMuleConfiguration(), xmlElement).get();
            if (result.isPresent()) {
                if (globalOrUnknown) {
                    muleEditor.getGlobalsEditor().selectEntry(result.get());
                } else {
                    muleEditor.getFlowEditor().selectEntity(result.get());
                }
            }
        });
    }

    private static boolean isGlobalOrUnknown(Element xmlElement, MuleConfiguration muleConfiguration) {
        Optional<IMessageFlowEntity> result = new FindEntity(muleConfiguration, xmlElement).get();
        return result.isPresent() && (ModelUtils.isGlobalElement((IMessageFlowEntity)result.get()) || ModelUtils.isGlobalUnknown((IMessageFlowEntity)result.get()));
    }

    private static class FindEntity
    extends MessageFlowEntityVisitorAdapter {
        private MuleConfiguration muleConfiguration;
        private Element element;
        private Optional<IMessageFlowEntity> result = Optional.empty();

        public FindEntity(MuleConfiguration muleConfiguration, Element element) {
            this.muleConfiguration = muleConfiguration;
            this.element = element;
        }

        public void defaultVisit(IMessageFlowEntity entity) {
            ElementWrapperW3C wrapper = (ElementWrapperW3C)entity.getElement();
            if (wrapper.getNode().equals(this.element)) {
                this.result = Optional.of(entity);
            } else if (entity instanceof IMessageFlowNode) {
                IReadOnlyPropertyCollection properties = ((IMessageFlowNode)entity).getProperties();
                properties.getPropertyCollections().forEach(propertyCollection -> this.visitPropertyCollections(entity, (IReadOnlyPropertyCollection)propertyCollection));
            }
        }

        private void visitPropertyCollections(IMessageFlowEntity entity, IReadOnlyPropertyCollection propertyCollection) {
            ElementWrapperW3C wrapper = (ElementWrapperW3C)propertyCollection.getElement();
            if (wrapper.getNode().equals(this.element) || this.isSomeChild(wrapper.getNode().getChildNodes())) {
                this.result = Optional.of(entity);
            } else {
                propertyCollection.getPropertyCollections().forEach(propCol -> this.visitPropertyCollections(entity, (IReadOnlyPropertyCollection)propCol));
            }
        }

        private boolean isSomeChild(NodeList childNodes) {
            int i = 0;
            while (i < childNodes.getLength()) {
                if (childNodes.item(i).equals(this.element)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public void visitMuleConfiguration(MuleConfiguration muleConfiguration) {
            super.visitMuleConfiguration(muleConfiguration);
            if (!this.result.isPresent()) {
                muleConfiguration.getFlows().forEach(flow -> flow.accept((MessageFlowEntityVisitor)this));
                muleConfiguration.getGlobalEntries().stream().forEach(element -> element.accept((MessageFlowEntityVisitor)this));
            }
        }

        public void visitCompartment(Compartment compartment) {
            super.visitCompartment(compartment);
            if (!this.result.isPresent()) {
                compartment.getLanes().forEach(lane -> lane.accept((MessageFlowEntityVisitor)this));
            }
        }

        public void visitCompartmentLane(CompartmentLane lane) {
            super.visitCompartmentLane(lane);
            if (!this.result.isPresent()) {
                lane.getCompartmentLaneEntries().forEach(entity -> entity.accept((MessageFlowEntityVisitor)this));
            }
        }

        public void visitContainer(Container container) {
            super.visitContainer(container);
            if (!this.result.isPresent()) {
                container.getNestedContainers().forEach(nestedContainer -> nestedContainer.accept((MessageFlowEntityVisitor)this));
            }
        }

        public void visitNestedContainer(NestedContainer nestedContainer) {
            super.visitNestedContainer(nestedContainer);
            if (!this.result.isPresent()) {
                nestedContainer.getCompartmentLaneEntries().forEach(entry -> entry.accept((MessageFlowEntityVisitor)this));
            }
        }

        public void visitSplitterNode(SplitterNode splitterNode) {
            this.visitCompartment(splitterNode.getCompartment());
        }

        public void visitRoute(Route route) {
            this.visitCompartmentLane((CompartmentLane)route);
        }

        public Optional<IMessageFlowEntity> get() {
            this.visitMuleConfiguration(this.muleConfiguration);
            return this.result;
        }
    }
}

