/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.messageflow.editor.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.tooling.core.utils.ComponentIdGeneratorSupplier;
import org.mule.tooling.core.utils.EclipseContextHelper;

public class DocIdReplacerUtils {
    private static final String DOC_ID_PREFIX = "doc:id=\"";
    private static final Pattern DOC_ID_PATTERN = Pattern.compile("doc:id=\"([^\\s]+\")");

    public static String replaceDocIds(String content) {
        Matcher m = DOC_ID_PATTERN.matcher(content);
        ComponentIdGeneratorSupplier supplier = (ComponentIdGeneratorSupplier)EclipseContextHelper.createFromStudioContext(ComponentIdGeneratorSupplier.class);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String uuid = DOC_ID_PREFIX + supplier.get().generate() + "\"";
            m.appendReplacement(sb, uuid);
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

