/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.service.configuration;

import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.ubp.plugin.meter.exporter.configuration.SendingQueueConfigurationTransformer;
import com.mulesoft.agent.ubp.plugin.service.MetricIngestion;
import com.mulesoft.agent.ubp.plugin.service.configuration.IngestionConfigurationException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class IngestionConfiguration
implements Serializable {
    public Map<String, String> endpoint = new HashMap<String, String>();
    public Map<String, String> sendingQueueConfiguration = new HashMap<String, String>();
    public String type;
    public String compression;
    public String exporterInterval;
    public String format;
    public Map<String, String> tls = new HashMap<String, String>();
    public String sendingQueue;
    public Map<String, String> proxy = new HashMap<String, String>();
    public Map<String, Object> retryOnFailureConfiguration;

    public Map<String, Object> toMap(SecurityConfiguration securityConfiguration, MetricIngestion metricIngestion, EncryptionService encryptionService) {
        String urlFromService;
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        configuration.put("ingestion.type", this.type);
        String url = null;
        if (metricIngestion != null) {
            url = metricIngestion.getEndpoint();
        }
        if (this.endpoint != null && (urlFromService = this.endpoint.get("url")) != null) {
            url = urlFromService;
        }
        if (url == null) {
            throw new IngestionConfigurationException("The url for the ingestion has to be provided");
        }
        configuration.put("ingestion.endpoint.url", url);
        if (this.sendingQueueConfiguration != null) {
            configuration.putAll((Map)SendingQueueConfigurationTransformer.getSendingQueueConfigurationTransformer().apply(this.sendingQueueConfiguration));
        }
        if (this.isHttps(url)) {
            try {
                configuration.put("ingestion.tls.keystore_file", securityConfiguration.getKeyStoreFile());
                configuration.put("ingestion.tls.keystore_password", encryptionService.decrypt(securityConfiguration.getKeyStorePassword()));
                if (this.tls != null) {
                    if (this.tls.get("keyStoreFile") != null) {
                        configuration.put("ingestion.tls.keystore_file", this.tls.get("keyStoreFile"));
                    }
                    if (this.tls.get("keyStorePassword") != null) {
                        configuration.put("ingestion.tls.keystore_password", encryptionService.decrypt(this.tls.get("keyStorePassword")));
                    }
                    if (this.tls.get("trustStoreFile") != null) {
                        configuration.put("ingestion.tls.truststore_file", this.tls.get("trustStoreFile"));
                    }
                    if (this.tls.get("trustStorePassword") != null) {
                        configuration.put("ingestion.tls.truststore_password", encryptionService.decrypt(this.tls.get("trustStorePassword")));
                    }
                    configuration.put("ingestion.tls.ca_file", this.tls.get("caFile"));
                    configuration.put("ingestion.tls.ca", this.tls.get("ca"));
                    configuration.put("ingestion.tls.cert_file", this.tls.get("certFile"));
                    configuration.put("ingestion.tls.cert", this.tls.get("cert"));
                    configuration.put("ingestion.tls.key_file", this.tls.get("keyFile"));
                    configuration.put("ingestion.tls.key", this.tls.get("key"));
                }
            }
            catch (AgentEncryptionException aee) {
                throw new IngestionConfigurationException((Exception)((Object)aee));
            }
        }
        if (this.proxy != null) {
            configuration.putAll(this.proxy);
        }
        configuration.put("telemetry.format", this.format);
        configuration.put("telemetry.metrics.export.interval", this.exporterInterval);
        configuration.put("telemetry.metrics.compression", this.compression);
        if (this.retryOnFailureConfiguration != null) {
            HashMap<String, Object> retryOnFailureParameters = new HashMap<String, Object>();
            retryOnFailureParameters.put("initial_backoff", this.retryOnFailureConfiguration.get("initialBackOff"));
            retryOnFailureParameters.put("max_attempts", this.retryOnFailureConfiguration.get("maxAttempts"));
            retryOnFailureParameters.put("backoff_multiplier", this.retryOnFailureConfiguration.get("backOffMultiplier"));
            retryOnFailureParameters.put("max_backoff", this.retryOnFailureConfiguration.get("maxBackoff"));
            configuration.put("telemetry.metrics.retry_on_failure", retryOnFailureParameters);
        }
        configuration.put("telemetry.metrics.sending_queue", this.sendingQueue);
        return configuration;
    }

    private boolean isHttps(String url) {
        return "https".equalsIgnoreCase(this.getProtocol(url));
    }

    private String getProtocol(String urlString) {
        try {
            URL url = new URL(urlString);
            return url.getProtocol();
        }
        catch (MalformedURLException e) {
            throw new IngestionConfigurationException(e);
        }
    }

    public Map<String, String> getEndpoint() {
        return this.endpoint;
    }

    public String getType() {
        return this.type;
    }

    public String getCompression() {
        return this.compression;
    }

    public String getExporterInterval() {
        return this.exporterInterval;
    }

    public String getFormat() {
        return this.format;
    }

    public Map<String, String> getTls() {
        return this.tls;
    }

    public String getSendingQueue() {
        return this.sendingQueue;
    }

    public Map<String, String> getProxy() {
        return this.proxy;
    }

    public Map<String, Object> getRetryOnFailureConfiguration() {
        return this.retryOnFailureConfiguration;
    }
}

