/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.service;

import com.google.inject.Singleton;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.injector.SchedulerServiceAware;
import com.mulesoft.agent.ubp.plugin.deployment.listener.MuleAgentUbpMetricsDeploymentListener;
import com.mulesoft.agent.ubp.plugin.deployment.listener.UbpMetricsDeploymentListener;
import com.mulesoft.agent.ubp.plugin.deployment.listener.registry.MuleAgentBaseCollectorRegistry;
import com.mulesoft.agent.ubp.plugin.service.DefaultMetricIngestionConfigurableAgentServiceEnablementResolver;
import com.mulesoft.agent.ubp.plugin.service.MetricIngestion;
import com.mulesoft.agent.ubp.plugin.service.MetricIngestionConfigurableAgentServiceEnablementResolver;
import com.mulesoft.agent.ubp.plugin.service.SchedulerPricingMetricsSamplerTaskManager;
import com.mulesoft.agent.ubp.plugin.service.configuration.EnvironmentConfiguration;
import com.mulesoft.agent.ubp.plugin.service.configuration.IngestionConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.api.sampler.PricingSamplerTaskManager;
import org.mule.ubp.meter.commons.cores.CoreCountCollectorProvider;

@Named(value="mule.agent.ubp.container.service")
@Singleton
public class UbpContainerService
extends ConfigurableAgentService
implements DeploymentServiceAware,
SchedulerServiceAware {
    public static final String CORE_COUNTER_SAMPLER_NAME = "core-counter";
    @Configurable(type=Type.DYNAMIC, value="{}")
    private IngestionConfiguration ingestionConfiguration;
    @Configurable(value="{}")
    private SecurityConfiguration security;
    @Configurable(value="{}")
    private MetricIngestion metricIngestion;
    @Inject
    private EncryptionService encryptionService;
    @Inject
    private AdministrationService administrationService;
    @Inject
    private ApplicationService agentApplicationService;
    private DeploymentService runtimeDeploymentService;
    private UbpMetricsDeploymentListener ubpMetricsDeploymentListener;
    private SchedulerService schedulerService;
    private SchedulerPricingMetricsSamplerTaskManager pricingSamplerManager;
    private Runnable startMethod = this::triggerCollection;
    private MetricIngestionConfigurableAgentServiceEnablementResolver metricIngestionConfigurableAgentServiceEnablementResolver = new DefaultMetricIngestionConfigurableAgentServiceEnablementResolver();

    public UbpContainerService() {
    }

    public UbpContainerService(Runnable startMethod, MetricIngestionConfigurableAgentServiceEnablementResolver metricIngestionConfigurableAgentServiceEnablementResolver) {
        this.startMethod = startMethod;
        this.metricIngestionConfigurableAgentServiceEnablementResolver = metricIngestionConfigurableAgentServiceEnablementResolver;
    }

    protected void doStart() {
        if (this.isEnabled()) {
            this.startMethod.run();
        }
    }

    private void triggerCollection() {
        Map<String, Object> globalConfiguration = this.resolveGlobalConfiguration();
        globalConfiguration.put("sampler_name", CORE_COUNTER_SAMPLER_NAME);
        this.pricingSamplerManager = new SchedulerPricingMetricsSamplerTaskManager(this.schedulerService, CORE_COUNTER_SAMPLER_NAME, Long.valueOf(1L), TimeUnit.HOURS);
        MuleAgentBaseCollectorRegistry collectorRegistry = new MuleAgentBaseCollectorRegistry(globalConfiguration, this.agentApplicationService, (PricingSamplerTaskManager)this.pricingSamplerManager);
        PricingStatsCollector coreCounterCollector = this.getCoreCounterCollectorProvider((CollectorRegistry)collectorRegistry);
        coreCounterCollector.startCollection();
        this.pricingSamplerManager.startSampling();
        this.ubpMetricsDeploymentListener = new MuleAgentUbpMetricsDeploymentListener(this.runtimeDeploymentService, this.agentApplicationService, this.schedulerService, globalConfiguration);
        this.runtimeDeploymentService.addDeploymentListener((DeploymentListener)this.ubpMetricsDeploymentListener);
    }

    protected void doStop() {
        if (this.ubpMetricsDeploymentListener != null) {
            this.runtimeDeploymentService.removeDeploymentListener((DeploymentListener)this.ubpMetricsDeploymentListener);
        }
        if (this.pricingSamplerManager != null) {
            this.pricingSamplerManager.stopSampling();
        }
    }

    public void enable(boolean state) throws AgentEnableOperationException {
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return Collections.emptyList();
    }

    public void setDeploymentService(DeploymentService deploymentService) {
        this.runtimeDeploymentService = deploymentService;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }

    public boolean isEnabled() {
        return this.metricIngestionConfigurableAgentServiceEnablementResolver.componentEnabled(this.metricIngestion, () -> super.isEnabled());
    }

    private Map<String, Object> resolveGlobalConfiguration() {
        HashMap<String, Object> globalConfiguration = new HashMap<String, Object>();
        Map<String, Object> ingestionConfigurationMap = this.ingestionConfiguration.toMap(this.security, this.metricIngestion, this.encryptionService);
        globalConfiguration.putAll(ingestionConfigurationMap);
        globalConfiguration.putAll(new EnvironmentConfiguration(this.administrationService).toMap());
        globalConfiguration.put("mulesoft.ingest.group", "hsa_core_count");
        return globalConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PricingStatsCollector getCoreCounterCollectorProvider(CollectorRegistry collectorRegistry) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            PricingStatsCollector pricingStatsCollector = new CoreCountCollectorProvider().get(collectorRegistry);
            return pricingStatsCollector;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

