/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.meter.exporter.sampler;

import com.mulesoft.ingestion.telemetry.TelemetryReporter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.mule.metrics.api.instrument.Instrument;
import org.mule.metrics.api.instrument.LongCounter;
import org.mule.metrics.api.instrument.LongGauge;
import org.mule.metrics.api.instrument.LongUpDownCounter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.sampler.PricingSamplerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UbpPluginMeterExporterSamplerTask
implements PricingSamplerTask {
    private static final String ERROR_UPDATING_INSTRUMENT_TEMPLATE = "Error while trying to update instrument [{}] of meter [{}] with context [{}]";
    private static final String ERROR_SAMPLING_INSTRUMENTS = "Error while trying to sample instruments.";
    private static final String SAMPLING_REGISTERED_INSTRUMENTS = "Sampling registered instruments.";
    private static final String UPDATING_INSTRUMENT = "Updating {} instrument {} from meter {}";
    private static final String LONG_GAUGE = "Long Gauge";
    private static final String LONG_COUNTER = "Long Counter";
    private static final Logger LOGGER = LoggerFactory.getLogger(UbpPluginMeterExporterSamplerTask.class);
    public static final String VALUE_IS = "Value is: {}";
    public static final String ATTRIBUTES_ARE = "Attributes are: {}";
    private static final List<String> REGISTRY_ATTRIBUTE_KEYS = Arrays.asList("asset_id", "mulesoft.ingest.group", "mulesoft.asset.sideloaded", "application_name");
    private final CollectorRegistry collectorRegistry;
    private final Map<LongCounter, Long> longCounterMap = new ConcurrentHashMap<LongCounter, Long>();
    private final Map<LongGauge, Long> longGaugeMap = new ConcurrentHashMap<LongGauge, Long>();
    private final TelemetryReporter telemetryReporter;

    public UbpPluginMeterExporterSamplerTask(TelemetryReporter telemetryReporter, CollectorRegistry collectorRegistry) {
        this.telemetryReporter = telemetryReporter;
        this.collectorRegistry = collectorRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample() {
        try {
            Map<LongCounter, Long> map = this.longCounterMap;
            synchronized (map) {
                LOGGER.debug(SAMPLING_REGISTERED_INSTRUMENTS);
                this.updateLongCounters();
                this.updateLongGauges();
            }
        }
        catch (Exception e) {
            LOGGER.error(ERROR_SAMPLING_INSTRUMENTS, (Throwable)e);
        }
    }

    private void updateLongGauges() {
        this.longGaugeMap.forEach((longGauge, value) -> this.failsafeInstrumentUpdate(instrument -> {
            LOGGER.debug(UPDATING_INSTRUMENT, new Object[]{LONG_GAUGE, instrument.getName(), instrument.getMeter().getName()});
            Map<String, Object> attributes = this.resolveMeasurementAttributes((Instrument)longGauge);
            LOGGER.debug(VALUE_IS, value);
            LOGGER.debug(ATTRIBUTES_ARE, attributes.keySet());
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(UbpPluginMeterExporterSamplerTask.class.getClassLoader());
                this.telemetryReporter.setLongGauge(longGauge.getName(), value.longValue(), attributes);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
            this.longGaugeMap.put((LongGauge)longGauge, longGauge.getValueAsLong());
        }, longGauge));
    }

    private void updateLongCounters() {
        this.longCounterMap.forEach((longCounter, previousValue) -> this.failsafeInstrumentUpdate(instrument -> this.longCounterMap.put((LongCounter)instrument, this.sampleAndIncreaseMetric((Long)previousValue, (LongCounter)instrument)), longCounter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long sampleAndIncreaseMetric(Long previousValue, LongCounter instrument) {
        LOGGER.debug(UPDATING_INSTRUMENT, new Object[]{LONG_COUNTER, instrument.getName(), instrument.getMeter().getName()});
        long sampledValue = instrument.getValueAsLong();
        long delta = sampledValue - previousValue;
        Map<String, Object> attributes = this.resolveMeasurementAttributes((Instrument)instrument);
        LOGGER.debug(VALUE_IS, (Object)delta);
        LOGGER.debug(ATTRIBUTES_ARE, attributes.keySet());
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(UbpPluginMeterExporterSamplerTask.class.getClassLoader());
            this.telemetryReporter.incrementLongCounter(instrument.getName(), delta, attributes);
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        return sampledValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForSampling(LongCounter longCounter) {
        Map<LongCounter, Long> map = this.longCounterMap;
        synchronized (map) {
            if (!this.longCounterMap.containsKey(longCounter)) {
                this.longCounterMap.put(longCounter, 0L);
                this.telemetryReporter.registerLongCounter(longCounter.getName(), longCounter.getDescription(), longCounter.getUnit());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerForSampling(LongGauge longGauge) {
        Map<LongGauge, Long> map = this.longGaugeMap;
        synchronized (map) {
            if (!this.longGaugeMap.containsKey(longGauge)) {
                this.longGaugeMap.put(longGauge, longGauge.getValueAsLong());
                this.telemetryReporter.registerLongGauge(longGauge.getName(), longGauge.getDescription(), longGauge.getUnit());
            }
        }
    }

    public synchronized void registerForSampling(LongUpDownCounter longUpDownCounter) {
        throw new UnsupportedOperationException("Up Down Counters are not supported");
    }

    public synchronized void dispose() {
    }

    private <T extends Instrument> void failsafeInstrumentUpdate(Consumer<T> instrumentUpdate, T instrument) {
        try {
            instrumentUpdate.accept(instrument);
        }
        catch (Exception e) {
            String applicationName = (String)this.collectorRegistry.get("application_name");
            String assetId = (String)this.collectorRegistry.get("asset_id");
            String contextInfo = this.buildApplicationContext(applicationName, assetId);
            LOGGER.error(ERROR_UPDATING_INSTRUMENT_TEMPLATE, new Object[]{instrument.getName(), instrument.getMeter().getName(), contextInfo, e});
        }
    }

    String buildApplicationContext(@Nullable String applicationName, @Nullable String assetId) {
        StringBuilder context = new StringBuilder();
        if (applicationName != null || assetId != null) {
            if (applicationName != null) {
                context.append(" with application [").append(applicationName).append("]");
            }
            if (assetId != null) {
                context.append(" with assetId [").append(assetId).append("]");
            }
        }
        return context.toString().trim();
    }

    private Map<String, Object> resolveMeasurementAttributes(Instrument instrument) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        instrument.getMeter().forEachAttribute(attributes::put);
        REGISTRY_ATTRIBUTE_KEYS.forEach(key -> this.addAttributeIfPresentInRegistry((Map<String, Object>)attributes, (String)key));
        return attributes;
    }

    private void addAttributeIfPresentInRegistry(Map<String, Object> attributes, String key) {
        Optional.ofNullable(this.collectorRegistry.get(key)).ifPresent(value -> attributes.put(key, value));
    }
}

