/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.meter.exporter.ingestion.client;

import com.mulesoft.agent.ubp.plugin.utils.UbpPluginConstants;
import com.mulesoft.ingestion.telemetry.TelemetryReporter;
import com.mulesoft.ingestion.telemetry.TelemetryReporterBuilder;
import java.util.HashMap;
import java.util.Properties;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;

public class IngestionClientTelemetryReporterFactory {
    private static final String RESOURCE_ATTRIBUTES_TEMPLATE = "%s.%s";
    private static TelemetryReporter telemetryReporter;

    public static TelemetryReporter getTelemetryReporter(MeterExporterConfiguration configuration) {
        return IngestionClientTelemetryReporterFactory.getTelemetryReporter(configuration, IngestionClientTelemetryReporterFactory.getTelemetryReporterBuilder());
    }

    public static TelemetryReporter getTelemetryReporter(MeterExporterConfiguration configuration, TelemetryReporterBuilder telemetryReporterBuilder) throws RuntimeException {
        if (telemetryReporter == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(IngestionClientTelemetryReporterFactory.class.getClassLoader());
                telemetryReporter = IngestionClientTelemetryReporterFactory.createTelemetryReporter(configuration, telemetryReporterBuilder);
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        return telemetryReporter;
    }

    private static TelemetryReporter createTelemetryReporter(MeterExporterConfiguration configuration, TelemetryReporterBuilder telemetryReporterBuilder) {
        Properties propertiesForReporter = new Properties();
        HashMap commonAttributesForReporter = new HashMap();
        UbpPluginConstants.getIngestionClientConfigurationAttributes().forEach(IngestionClientTelemetryReporterFactory.addIngestionClientConfigurationPropertiesIfNotNull(configuration, propertiesForReporter));
        UbpPluginConstants.resourceConfigurationAttributes().forEach(IngestionClientTelemetryReporterFactory.addKeyTelemetryReporterIfNotNull(configuration, propertiesForReporter));
        try {
            telemetryReporterBuilder.withProperties(propertiesForReporter).withCommonDataPointAttributes(commonAttributesForReporter);
            return telemetryReporterBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static TelemetryReporterBuilder getTelemetryReporterBuilder() {
        return TelemetryReporter.builder();
    }

    private static Consumer<String> addIngestionClientConfigurationPropertiesIfNotNull(MeterExporterConfiguration configuration, Properties propertiesForReporter) {
        return key -> {
            String value = configuration.getStringValue(key);
            if (value != null) {
                propertiesForReporter.put(key, configuration.getStringValue(key));
            }
        };
    }

    private static Consumer<String> addKeyTelemetryReporterIfNotNull(MeterExporterConfiguration configuration, Properties commonAttributesForReporter) {
        return key -> {
            String value = configuration.getStringValue(key);
            if (value != null) {
                commonAttributesForReporter.put(String.format(RESOURCE_ATTRIBUTES_TEMPLATE, "telemetry.resource", key), value);
            }
        };
    }

    public static void reset() {
        telemetryReporter = null;
    }
}

