/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.meter.exporter.configuration;

import com.mulesoft.agent.ubp.plugin.meter.exporter.configuration.ConfigurationTransformer;
import java.nio.file.FileSystems;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SendingQueueConfigurationTransformer
implements ConfigurationTransformer {
    private static final ConfigurationTransformer INSTANCE = new SendingQueueConfigurationTransformer();
    public static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    public static final String MULE_RUNTIME_DOT_MULE = ".mule";
    public static final String METRICS_BUFFERING_FOLDER = "metrics_buffering";

    public static ConfigurationTransformer getSendingQueueConfigurationTransformer() {
        return INSTANCE;
    }

    private SendingQueueConfigurationTransformer() {
    }

    @Override
    public Map<String, String> apply(Map<String, String> sendingQueueConfiguration) {
        HashMap<String, String> configuration = new HashMap<String, String>();
        String sendingQueueType = sendingQueueConfiguration.get("type");
        if (sendingQueueType != null) {
            configuration.put("telemetry.metrics.sending_queue.type", sendingQueueType);
        } else {
            sendingQueueType = "disk";
            configuration.put("telemetry.metrics.sending_queue.type", sendingQueueType);
        }
        if ("disk".equals(sendingQueueType)) {
            Optional.ofNullable(SendingQueueConfigurationTransformer.resolveSendingQueueDiskRootDir(sendingQueueConfiguration)).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.root_dir", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("debugEnabled")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.debug_enabled", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("maxFileSize")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.max_file_size", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("maxFolderSize")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.max_folder_size", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("maxFileAgeWrite")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.max_file_age_write", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("minFileAgeRead")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.min_file_age_read", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("maxFileAgeRead")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.max_file_age_read", (String)value));
            Optional.ofNullable(sendingQueueConfiguration.get("scanFrequency")).map(value -> configuration.put("telemetry.metrics.sending_queue.disk.scan_frequency", (String)value));
        }
        return configuration;
    }

    public static String resolveSendingQueueDiskRootDir(Map<String, String> sendingQueueConfiguration) {
        String rootDirPath = sendingQueueConfiguration.get("rootDirectory");
        if (rootDirPath != null) {
            return rootDirPath;
        }
        String muleHomeDir = System.getProperty("mule.home");
        if (muleHomeDir != null) {
            return muleHomeDir + FILE_SEPARATOR + MULE_RUNTIME_DOT_MULE + FILE_SEPARATOR + METRICS_BUFFERING_FOLDER;
        }
        return null;
    }
}

