/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.meter.exporter;

import com.mulesoft.agent.ubp.plugin.meter.exporter.ingestion.client.IngestionClientTelemetryReporterFactory;
import com.mulesoft.agent.ubp.plugin.meter.exporter.sampler.UbpPluginMeterExporterSamplerTask;
import com.mulesoft.ingestion.telemetry.TelemetryReporter;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.mule.metrics.api.instrument.LongCounter;
import org.mule.metrics.api.instrument.LongGauge;
import org.mule.metrics.api.instrument.LongUpDownCounter;
import org.mule.metrics.api.meter.Meter;
import org.mule.metrics.exporter.api.MeterExporter;
import org.mule.metrics.exporter.config.api.MeterExporterConfiguration;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.sampler.PricingSamplerTask;

public class UbpPluginMeterExporter
implements MeterExporter {
    private final CollectorRegistry collectorRegistry;
    private final Supplier<TelemetryReporter> telemetryReporterSupplier;
    private final BiFunction<TelemetryReporter, CollectorRegistry, UbpPluginMeterExporterSamplerTask> pricingSamplerTaskCreator;
    private UbpPluginMeterExporterSamplerTask sampler;

    public UbpPluginMeterExporter(CollectorRegistry collectorRegistry, Supplier<TelemetryReporter> telemetryReporterSupplier, BiFunction<TelemetryReporter, CollectorRegistry, UbpPluginMeterExporterSamplerTask> pricingSamplerTaskCreator) {
        this.collectorRegistry = collectorRegistry;
        this.telemetryReporterSupplier = telemetryReporterSupplier;
        this.pricingSamplerTaskCreator = pricingSamplerTaskCreator;
    }

    public UbpPluginMeterExporter(MeterExporterConfiguration configuration, CollectorRegistry collectorRegistry) {
        this(collectorRegistry, () -> IngestionClientTelemetryReporterFactory.getTelemetryReporter(configuration), UbpPluginMeterExporterSamplerTask::new);
    }

    public void registerMeterToExport(Meter meter) {
        this.sampler = this.pricingSamplerTaskCreator.apply(this.telemetryReporterSupplier.get(), this.collectorRegistry);
        this.collectorRegistry.getPricingSamplerManager().addPricingSampler((String)this.collectorRegistry.get("sampler_name"), (PricingSamplerTask)this.sampler);
    }

    public void enableExport(LongCounter longCounter) {
        this.sampler.registerForSampling(longCounter);
    }

    public void enableExport(LongUpDownCounter upDownCounter) {
        this.sampler.registerForSampling(upDownCounter);
    }

    public void enableExport(LongGauge longGauge) {
        this.sampler.registerForSampling(longGauge);
    }

    public void dispose() {
        this.sampler.dispose();
    }
}

